package com.atlassian.jira.event.issue.field;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.Internal;

/**
 * since 8.16
 */
@EventName("administration.customfields.rest.bulk.delete.selected")
public class CustomFieldSelectedForDeletionEvent {

    private final Long customFieldId;
    private final Long lastValueUpdate;
    private final Long issuesWithValue;
    private final Long numberOfProjects;
    private final Long numberOfScreens;
    private final boolean deleted;
    private final Long startTime;
    private final Long endTime;
    private final Long bulkStartTime;

    @Internal
    public CustomFieldSelectedForDeletionEvent(final Long customFieldId,
                                               final Long lastValueUpdate,
                                               final Long issuesWithValue,
                                               final Long numberOfProjects,
                                               final Long numberOfScreens,
                                               final boolean deleted,
                                               final Long startTime,
                                               final Long endTime,
                                               final Long bulkStartTime) {
        this.customFieldId = customFieldId;
        this.lastValueUpdate = lastValueUpdate;
        this.issuesWithValue = issuesWithValue;
        this.numberOfProjects = numberOfProjects;
        this.numberOfScreens = numberOfScreens;
        this.deleted = deleted;
        this.startTime = startTime;
        this.endTime = endTime;
        this.bulkStartTime = bulkStartTime;
    }

    public Long getCustomFieldId() {
        return customFieldId;
    }

    public Long getLastValueUpdate() {
        return lastValueUpdate;
    }

    public Long getIssuesWithValue() {
        return issuesWithValue;
    }

    public Long getNumberOfProjects() {
        return numberOfProjects;
    }

    public Long getNumberOfScreens() {
        return numberOfScreens;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public Long getStartTime() {
        return startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public Long getBulkStartTime() {
        return bulkStartTime;
    }
}

