package com.atlassian.jira.event.issue;

import com.atlassian.annotations.Internal;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * This event will be fired whenever archived issues are exported.
 *
 */
@Internal
public final class ArchivedIssueExportEvent {

    private final long issuesTotal;
    private final List<String> projectsKeys;

    public ArchivedIssueExportEvent(long issuesTotal, List<String> projectsKeys) {
        this.issuesTotal = issuesTotal;
        this.projectsKeys = (projectsKeys == null ? Collections.emptyList() : projectsKeys);
    }

    public long getIssuesTotal() {
        return issuesTotal;
    }

    @Nonnull
    public List<String> getProjectsKeys() {
        return projectsKeys;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final ArchivedIssueExportEvent that = (ArchivedIssueExportEvent) o;
        return Objects.equals(issuesTotal, that.issuesTotal) &&
                Objects.equals(projectsKeys, that.projectsKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(issuesTotal, projectsKeys);
    }
}
