package com.atlassian.jira.event.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.status.Status;

import java.util.Objects;

/**
 * Published when issue status is successfully moved in sequence of statuses.
 */
@Internal
public class StatusMovedEvent extends AbstractEvent {
    private final Status status;
    private final Long from;
    private final Long to;

    public StatusMovedEvent(Status status, Long from, Long to) {
        super();
        this.status = status;
        this.from = from;
        this.to = to;
    }

    public Status getStatus() {
        return status;
    }

    public Long getFrom() {
        return from;
    }

    public Long getTo() {
        return to;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }

        StatusMovedEvent that = (StatusMovedEvent) o;
        return Objects.equals(status, that.status) &&
                Objects.equals(from, that.from) &&
                Objects.equals(to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), status, from, to);
    }

    @Override
    public String toString() {
        return "StatusMovedEvent{" +
                "status=" + status +
                "from=" + from +
                "to=" + to +
                '}';
    }
}
