package com.atlassian.jira.event.announcement;

public final class AnnouncementBannerChangedEvent {

    private final String previousBanner;
    private final String newBanner;
    private final String previousVisibility;
    private final String newVisibility;

    public AnnouncementBannerChangedEvent(final String previousBanner,
                                          final String newBanner,
                                          final String previousVisibility,
                                          final String newVisibility) {
        this.previousBanner = previousBanner;
        this.newBanner = newBanner;
        this.previousVisibility = previousVisibility;
        this.newVisibility = newVisibility;
    }

    public String getPreviousBanner() {
        return previousBanner;
    }

    public String getNewBanner() {
        return newBanner;
    }

    public String getPreviousVisibility() {
        return previousVisibility;
    }

    public String getNewVisibility() {
        return newVisibility;
    }
}
