package com.atlassian.jira.config;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Allows to check whether the DC-only feature is enabled
 *
 * @since 8.16
 */
@ExperimentalApi
public interface DCFeatureLicenseChecker {

    /**
     * Checks whether feature is enabled and Jira is DC licensed
     *
     * @param featureKey  the feature key to check
     * @return true if {@code feature} is enabled and Jira is DC licensed; false otherwise
     * @see com.atlassian.jira.config.FeatureManager#isEnabled(String)
     */
    boolean isEnabled(String featureKey);

    /**
     * Checks whether feature flag is enabled and Jira is DC licensed
     *
     * @param featureFlag  the feature flag to check
     * @return true if {@code featureFlag} is enabled and Jira is DC licensed; false otherwise
     * @see com.atlassian.jira.config.FeatureManager#isEnabled(FeatureFlag)
     */
    boolean isEnabled(FeatureFlag featureFlag);
}
