package com.atlassian.jira.bc.dataimport;

/**
 * Event raised when XML server export finishes with a success.
 *
 * @since v8.0
 */
public class ExportSuccessfulEvent implements DataExportEvent {

    private final long xmlExportTime;
    private final long exportDuration;

    ExportSuccessfulEvent(long xmlExportTime, long exportDuration) {
        this.xmlExportTime = xmlExportTime;
        this.exportDuration = exportDuration;
    }

    @Override
    public Long getXmlExportTime() {
        return xmlExportTime;
    }

    public Long getExportDuration() {
        return exportDuration;
    }
}
