package com.atlassian.jira.auditing;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * @since v6.2
 * {@link AssociatedItem.Type} is used when mapping database entries to audit objects. Please be considerate of extending
 * this enum as removing {@link AssociatedItem.Type}s will not be possible without altering already stored data.
 *
 * @deprecated since v8.12 <br/> Use {@link com.atlassian.audit.entity.AuditResource} instead.
 */
@Deprecated
@ExperimentalApi
public interface AssociatedItem {
    enum Type {
        USER,
        PROJECT,
        GROUP,
        SCHEME,
        REMOTE_DIRECTORY,
        WORKFLOW,
        PERMISSIONS,
        VERSION,
        CUSTOM_FIELD,
        PROJECT_CATEGORY,
        PROJECT_COMPONENT,
        PROJECT_ROLE,
        LICENSE,
        APPLICATION_ROLE,
        SCREEN,
        SPRINT,
        BOARD,
        ISSUE_TYPE,
        GENERAL_CONFIGURATION_OPTION,
        DASHBOARD,
        FILTER,
        FEATURE,
        JIRA_SERVICE,
        ISSUE,
        FIELD_CONFIG_SCHEME,
        ISSUE_LINK_TYPE,
        RESOLUTION,
        UNKNOWN_USER,
        APPLICATION_LINK,
        PLUGIN,
        CLUSTER_NODE,
        STATUS,
        PRIORITY,
        /**
         * Value intended for internal use only. Requests containing this value will be rejected.
         */
        @Internal
        UNSPECIFIED,
        ISSUE_SECURITY_LEVEL
    }

    @Nonnull
    String getObjectName();

    @Nullable
    String getObjectId();

    @Nullable
    String getParentName();

    @Nullable
    String getParentId();

    @Nonnull
    Type getObjectType();
}
