/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.config.item.DefaultValueConfigItem;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@PublicSpi
public abstract class AbstractCustomFieldType<T, S>
implements CustomFieldType<T, S> {
    private CustomFieldTypeModuleDescriptor descriptor;

    @Override
    public void init(CustomFieldTypeModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public final String getKey() {
        return this.descriptor.getCompleteKey();
    }

    @Override
    public final String getName() {
        return this.descriptor.getName();
    }

    @Override
    public final String getDescription() {
        return this.descriptor.getDescription();
    }

    @Override
    public final CustomFieldTypeModuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        return MapBuilder.newBuilder().add("issueGv", issue != null ? issue.getGenericValue() : null).toMutableMap();
    }

    public final Map getVelocityParameters(Issue issue) throws IllegalAccessException {
        throw new IllegalAccessException("subclasses should override and use the 3-param version");
    }

    @Override
    @Nonnull
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        return Lists.newArrayList((Object[])new FieldConfigItemType[]{new DefaultValueConfigItem()});
    }

    @Override
    public List<FieldIndexer> getRelatedIndexers(CustomField customField) {
        return null;
    }

    @Override
    public boolean isRenderable() {
        return false;
    }

    @Override
    public boolean valuesEqual(T v1, T v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    @Override
    public String getChangelogString(CustomField field, T value) {
        return null;
    }

    protected void assertObjectImplementsType(Class<?> clazz, Object o) {
        if (o == null) {
            return;
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            throw new ClassCastException(this.getClass() + " passed an invalid value of type: " + o.getClass());
        }
    }

    @Override
    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return null;
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    public Object accept(VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visit(this);
        }
        return null;
    }

    public static interface Visitor<X>
    extends VisitorBase<X> {
        public X visit(AbstractCustomFieldType var1);
    }

    public static interface VisitorBase<X> {
    }
}

