/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class DelimeterInserter {
    private String frontDelimeter;
    private String endDelimeter;
    private boolean prefixMode;
    private boolean caseInsensitive;
    private String consideredWhitespace;

    public DelimeterInserter(String frontDelimeter, String endDelimeter) {
        this(frontDelimeter, endDelimeter, true, true);
    }

    public DelimeterInserter(String frontDelimeter, String endDelimeter, boolean prefixMode) {
        this(frontDelimeter, endDelimeter, prefixMode, true);
    }

    public DelimeterInserter(String frontDelimeter, String endDelimeter, boolean prefixMode, boolean caseInsensitive) {
        this.frontDelimeter = frontDelimeter;
        this.endDelimeter = endDelimeter;
        this.prefixMode = prefixMode;
        this.caseInsensitive = caseInsensitive;
    }

    public String getConsideredWhitespace() {
        return this.consideredWhitespace;
    }

    public void setConsideredWhitespace(String consideredWhitespace) {
        this.consideredWhitespace = consideredWhitespace;
    }

    private boolean isAtStartOfWord(String targetString, int startIndex) {
        if (startIndex == 0) {
            return true;
        }
        char previousCh = targetString.charAt(startIndex - 1);
        return Character.isWhitespace(previousCh) || this.consideredWhitespace != null && this.consideredWhitespace.indexOf(previousCh) != -1;
    }

    public String insert(String targetString, String[] terms) {
        if (targetString == null) {
            throw new IllegalArgumentException("targetString must be non null!");
        }
        this.frontDelimeter = this.frontDelimeter == null ? "" : this.frontDelimeter;
        this.endDelimeter = this.endDelimeter == null ? "" : this.endDelimeter;
        String[] stringArray = terms = terms == null ? new String[]{} : terms;
        if (terms.length == 0) {
            return targetString;
        }
        if (this.frontDelimeter.length() == 0 && this.endDelimeter.length() == 0) {
            return targetString;
        }
        ArrayList markers = Lists.newArrayListWithCapacity((int)terms.length);
        Arrays.sort(terms, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s2;
                String s1 = (String)(o1 != null ? o1 : "");
                if (s1.equals(s2 = (String)(o2 != null ? o2 : ""))) {
                    return 0;
                }
                if (s1.length() == s2.length()) {
                    return s1.compareTo(s2);
                }
                return s2.length() - s1.length();
            }
        });
        String matchString = this.caseInsensitive ? targetString.toLowerCase() : targetString;
        block0: for (String term1 : terms) {
            int currentIndex = 0;
            String term = term1;
            if (StringUtils.isBlank((CharSequence)term)) continue;
            term = this.caseInsensitive ? term.toLowerCase() : term;
            while (true) {
                int startIndex = matchString.indexOf(term, currentIndex);
                int endIndex = startIndex + term.length();
                if (startIndex == -1) continue block0;
                currentIndex = endIndex;
                DelimeterMarker newMarker = new DelimeterMarker(startIndex, endIndex, targetString);
                if (markers.size() == 0) {
                    if (this.prefixMode) {
                        if (!this.isAtStartOfWord(targetString, startIndex)) continue;
                        markers.add(newMarker);
                        continue;
                    }
                    markers.add(newMarker);
                    continue;
                }
                boolean addMarker = true;
                for (Object marker : markers) {
                    DelimeterMarker m1 = (DelimeterMarker)marker;
                    if (m1.containsAllOf(newMarker)) {
                        addMarker = false;
                        break;
                    }
                    if (!m1.containsSomeOf(newMarker)) continue;
                    m1.extendToInclude(newMarker);
                    addMarker = false;
                    break;
                }
                if (!addMarker) continue;
                if (this.prefixMode) {
                    if (!this.isAtStartOfWord(matchString, startIndex)) continue;
                    markers.add(newMarker);
                    continue;
                }
                markers.add(newMarker);
            }
        }
        Collections.sort(markers, new Comparator(){

            public int compare(Object o1, Object o2) {
                DelimeterMarker m1 = (DelimeterMarker)o1;
                DelimeterMarker m2 = (DelimeterMarker)o2;
                return m1.startIndex - m2.startIndex;
            }
        });
        Iterator iterator = markers.iterator();
        ArrayList mergedList = Lists.newArrayListWithCapacity((int)markers.size());
        if (iterator.hasNext()) {
            DelimeterMarker currentMarker = (DelimeterMarker)iterator.next();
            mergedList.add(currentMarker);
            while (iterator.hasNext()) {
                DelimeterMarker next = (DelimeterMarker)iterator.next();
                if (currentMarker.containsSomeOf(next)) {
                    currentMarker.extendToInclude(next);
                    continue;
                }
                currentMarker = next;
                mergedList.add(currentMarker);
            }
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (DelimeterMarker m1 : mergedList) {
            String subStr = targetString.substring(index, m1.getStartIndex());
            sb.append(subStr);
            sb.append(this.frontDelimeter);
            subStr = targetString.substring(m1.getStartIndex(), m1.getEndIndex());
            sb.append(subStr);
            sb.append(this.endDelimeter);
            index = m1.getEndIndex();
            if (index < targetString.length()) continue;
            break;
        }
        if (index < targetString.length()) {
            String subStr = targetString.substring(index);
            sb.append(subStr);
        }
        return sb.toString();
    }

    private static class DelimeterMarker {
        private int startIndex;
        private int endIndex;
        private final String targetString;

        public DelimeterMarker(int startIndex, int endIndex, String targetString) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.targetString = targetString;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public boolean containsAllOf(DelimeterMarker m) {
            return this.startIndex <= m.startIndex && this.endIndex >= m.endIndex;
        }

        public boolean containsSomeOf(DelimeterMarker m) {
            if (m.startIndex < this.startIndex) {
                return this.isWithin(m.endIndex);
            }
            if (m.endIndex > this.endIndex) {
                return this.isWithin(m.startIndex);
            }
            return false;
        }

        private boolean isWithin(int sIndex) {
            return sIndex >= this.startIndex && sIndex <= this.endIndex;
        }

        public void extendToInclude(DelimeterMarker m) {
            if (this.containsSomeOf(m)) {
                this.startIndex = Math.min(this.startIndex, m.startIndex);
                this.endIndex = Math.max(this.endIndex, m.endIndex);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DelimeterMarker");
            sb.append(" si : ");
            sb.append(this.startIndex);
            sb.append(" ei : ");
            sb.append(this.endIndex);
            sb.append(" ( ");
            sb.append(this.targetString.substring(this.startIndex, this.endIndex));
            sb.append(" ) ");
            return sb.toString();
        }
    }
}

