/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import java.util.List;

public class UserFitsNavigatorHelper {
    private final UserSearchService userSearchService;

    public UserFitsNavigatorHelper(UserSearchService userSearchService) {
        this.userSearchService = userSearchService;
    }

    public String checkUser(String name) {
        String user = this.findUserName(name);
        if (user != null) {
            return user;
        }
        if (this.userExistsByFullNameOrEmail(name)) {
            return null;
        }
        return name;
    }

    String findUserName(String name) {
        ApplicationUser user = UserUtils.getUser(name.toLowerCase());
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    boolean userExistsByFullNameOrEmail(String name) {
        UserSearchParams userSearchParams = new UserSearchParams.Builder().includeActive(true).canMatchEmail(true).build();
        List<ApplicationUser> users = this.userSearchService.findUsers(name, userSearchParams);
        for (ApplicationUser applicationUser : users) {
            String displayName = applicationUser.getDisplayName();
            String emailAddress = applicationUser.getEmailAddress();
            if (displayName != null && displayName.equalsIgnoreCase(name)) {
                return true;
            }
            if (emailAddress == null || !emailAddress.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

