/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class JiraDateUtils {
    public static final long SECONDS_IN_MILLIS = 1000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final String SECONDS = " seconds";
    private static final String MILLIS = " ms";

    public static String formatTime(long time) {
        if (time > 60000L) {
            return JiraDateUtils.formatMinutes(time);
        }
        if (time > 1000L) {
            return JiraDateUtils.formatSeconds(time);
        }
        return JiraDateUtils.formatMillis(time);
    }

    private static String formatMinutes(long time) {
        return JiraDateUtils.formatSeconds(time);
    }

    private static String formatSeconds(long time) {
        long kbsize = Math.round((float)time / 1000.0f);
        return String.valueOf(kbsize) + SECONDS;
    }

    private static String formatMillis(long time) {
        return time + MILLIS;
    }

    public static Date copyDateNullsafe(Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static Date copyOrCreateDateNullsafe(Date date) {
        return date == null ? new Date() : new Date(date.getTime());
    }

    public static Timestamp copyOrCreateTimestampNullsafe(Date date) {
        return date == null ? new Timestamp(System.currentTimeMillis()) : new Timestamp(date.getTime());
    }

    public static boolean hasTimeComponent(Date date, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timeZone);
        cal.setTime(date);
        cal.getTime();
        return cal.get(11) != 0 || cal.get(12) != 0;
    }
}

