/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public final class SearcherGroup {
    private final SearcherGroupType type;
    private final List<IssueSearcher<?>> searchers;
    private final boolean printHeader;

    public SearcherGroup(SearcherGroupType type, Collection<IssueSearcher<?>> searchers) {
        this.type = Assertions.notNull("type", type);
        this.printHeader = StringUtils.isNotBlank((CharSequence)type.getI18nKey());
        this.searchers = CollectionUtil.copyAsImmutableList(Assertions.containsNoNulls("searchers", searchers));
    }

    public String getTitleKey() {
        return this.type.getI18nKey();
    }

    public List<IssueSearcher<?>> getSearchers() {
        return this.searchers;
    }

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public SearcherGroupType getType() {
        return this.type;
    }

    public boolean isShown(ApplicationUser searcher, SearchContext searchContext) {
        Assertions.notNull("searchContext", searchContext);
        for (IssueSearcher<?> issueSearcher : this.searchers) {
            if (!issueSearcher.getSearchRenderer().isShown(searcher, searchContext)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("Searcher Group: [Type: %s, Searchers: %s].", new Object[]{this.type, this.searchers});
    }
}

