/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public class ChangeHistory
implements WithId {
    private GenericValue changeHistory;
    private IssueManager issueManager;
    private List<GenericValue> changeItems;
    private ApplicationUser user;
    private final UserManager userManager;

    public ChangeHistory(GenericValue changeHistoryGV, IssueManager issueManager) {
        this(changeHistoryGV, issueManager, ComponentAccessor.getUserManager());
    }

    public ChangeHistory(GenericValue changeHistoryGV, IssueManager issueManager, UserManager userManager) {
        this.changeHistory = changeHistoryGV;
        this.issueManager = issueManager;
        this.userManager = userManager;
    }

    @Override
    public Long getId() {
        return this.changeHistory.getLong("id");
    }

    public String getUsername() {
        ApplicationUser authorUser = this.getAuthorUser();
        if (authorUser == null) {
            return null;
        }
        return authorUser.getName();
    }

    public String getAuthor() {
        return this.getAuthorKey();
    }

    public String getAuthorKey() {
        return this.changeHistory.getString("author");
    }

    public ApplicationUser getAuthorObject() {
        String authorKey = this.getAuthorKey();
        if (authorKey == null) {
            return null;
        }
        if (this.user == null) {
            this.user = this.userManager.getUserByKeyEvenWhenUnknown(authorKey);
        }
        return this.user;
    }

    public ApplicationUser getAuthorUser() {
        return this.getAuthorObject();
    }

    public String getAuthorDisplayName() {
        ApplicationUser author = this.getAuthorObject();
        return author != null ? author.getDisplayName() : null;
    }

    public String getFullName() {
        return this.getAuthorDisplayName();
    }

    public Timestamp getTimePerformed() {
        return this.changeHistory.getTimestamp("created");
    }

    public String getLevel() {
        return this.changeHistory.getString("level");
    }

    public String getComment() {
        return this.changeHistory.getString("body");
    }

    public List<ChangeItemBean> getChangeItemBeans() {
        return this.getChangeItems().stream().map(changeItemGV -> new ChangeItemBean(changeItemGV.getString("fieldtype"), changeItemGV.getString("field"), changeItemGV.getString("oldvalue"), changeItemGV.getString("oldstring"), changeItemGV.getString("newvalue"), changeItemGV.getString("newstring"), this.getTimePerformed())).collect(Collectors.toList());
    }

    public List<GenericValue> getChangeItems() {
        if (this.changeItems == null) {
            try {
                this.changeItems = this.changeHistory.getRelated("ChildChangeItem");
            }
            catch (GenericEntityException genericEntityException) {
                // empty catch block
            }
            if (this.changeItems == null) {
                this.changeItems = Collections.emptyList();
            }
        }
        return this.changeItems;
    }

    public Issue getIssue() {
        return this.issueManager.getIssueObject(this.getIssueId());
    }

    public Long getIssueId() {
        return this.changeHistory.getLong("issue");
    }
}

