/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Apr 15, 2004
 * Time: 1:43:25 PM
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;

import java.util.Map;
import java.util.Optional;

import static com.atlassian.jira.workflow.JiraWorkflow.ACTION_SCREEN_ATTRIBUTE;

public class WorkflowActionsBean {
    public static final long VIEW_COMMENTASSIGN_ID = 2;
    public static final long VIEW_RESOLVE_ID = 3;

    private static final Map<String, Long> screensForViews = ImmutableMap.of(
        WorkflowTransitionUtil.VIEW_COMMENTASSIGN, VIEW_COMMENTASSIGN_ID,
        WorkflowTransitionUtil.VIEW_RESOLVE, VIEW_RESOLVE_ID
    );

    private static final Map<String, String> availableViews = ImmutableMap.of(
            "", "No view for transition",
            WorkflowTransitionUtil.VIEW_COMMENTASSIGN, "Add comment and assign",
            WorkflowTransitionUtil.VIEW_RESOLVE, "Add comment, assign and set resolution"
    );

    private FieldScreenManager fieldScreenManager;


    public Map<String, String> getAvailableViews() {
        return availableViews;
    }

    public String getSelectedView() {
        return WorkflowTransitionUtil.VIEW_COMMENTASSIGN;
    }

    public FieldScreen getFieldScreenForView(ActionDescriptor actionDescriptor) {
        final Optional<Long> fieldScreenIdForView = getFieldScreenIdForView(actionDescriptor);
        if(!fieldScreenIdForView.isPresent()) {
            return null;
        }

        FieldScreen fieldScreen = getFieldScreenManager().getFieldScreen(fieldScreenIdForView.get());
        if (fieldScreen != null) {
            return fieldScreen;
        } else {
            throw new IllegalArgumentException("Cannot find Screen with id '" + fieldScreenIdForView.get() + "'.");
        }
    }

    public Optional<Long> getFieldScreenIdForView(ActionDescriptor actionDescriptor) {
        String view = actionDescriptor.getView();
        if (TextUtils.stringSet(view)) {
            if (screensForViews.containsKey(view)) {
                return Optional.ofNullable(screensForViews.get(view));
            } else {
                if (actionDescriptor.getMetaAttributes().containsKey(ACTION_SCREEN_ATTRIBUTE)) {
                    return Optional.of(new Long((String) actionDescriptor.getMetaAttributes().get(ACTION_SCREEN_ATTRIBUTE)));
                } else {
                    throw new IllegalArgumentException("Unknown workflow view '" + view + "', or cannot find attribute '" +
                            ACTION_SCREEN_ATTRIBUTE + "' for workflow action '" + actionDescriptor.getId() + "'.");
                }
            }
        } else {
            return Optional.empty();
        }
    }

    private FieldScreenManager getFieldScreenManager() {
        if (fieldScreenManager == null) {
            fieldScreenManager = ComponentAccessor.getFieldScreenManager();
        }

        return fieldScreenManager;
    }
}
