package com.atlassian.jira.user.anonymize;

/**
 * @see AffectedEntity
 * @since 8.3
 */
public enum AffectedEntityType {
    /**
     * Entities for which the user properties, like user key/username, can be automatically updated.
     */
    ANONYMIZE,
    /**
     * Entities for which the ownership has to be transferred because they won't work correctly for deactivated users.
     */
    TRANSFER_OWNERSHIP,
    /**
     * Entities that relate only to the user being anonymized and can be safely removed. Should not affect other parts of the system/other users.
     */
    REMOVE,
    /**
     * Entities that can't be automatically and safely updated and require manual inspection.
     */
    MANUAL
}
