package com.atlassian.jira.user;

import java.util.Objects;

public final class UserDefaultSettings {
    private final String preferences;
    private final Boolean isNotifyUserAboutOwnChangesEnabled;
    private final Boolean isSharePrivateEnabled;
    private final Integer issuesPerPage;
    private final Boolean isAutowatchEnabled;

    public UserDefaultSettings(
            String preferences,
            Boolean isNotifyUserAboutOwnChangesEnabled,
            Boolean isSharePrivateEnabled,
            Integer issuesPerPage,
            Boolean isAutowatchEnabled
    ) {
        this.preferences = preferences;
        this.isNotifyUserAboutOwnChangesEnabled = isNotifyUserAboutOwnChangesEnabled;
        this.isSharePrivateEnabled = isSharePrivateEnabled;
        this.issuesPerPage = issuesPerPage;
        this.isAutowatchEnabled = isAutowatchEnabled;
    }

    public String getPreferences() {
        return preferences;
    }

    public Boolean isNotifyUserAboutOwnChangesEnabled() {
        return isNotifyUserAboutOwnChangesEnabled;
    }

    public Boolean isSharePrivateEnabled() {
        return isSharePrivateEnabled;
    }

    public Integer getIssuesPerPage() {
        return issuesPerPage;
    }

    public Boolean isAutowatchEnabled() {
        return isAutowatchEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserDefaultSettings that = (UserDefaultSettings) o;
        return Objects.equals(preferences, that.preferences) &&
                Objects.equals(isNotifyUserAboutOwnChangesEnabled, that.isNotifyUserAboutOwnChangesEnabled) &&
                Objects.equals(isSharePrivateEnabled, that.isSharePrivateEnabled) &&
                Objects.equals(issuesPerPage, that.issuesPerPage) &&
                Objects.equals(isAutowatchEnabled, that.isAutowatchEnabled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preferences, isNotifyUserAboutOwnChangesEnabled, isSharePrivateEnabled, issuesPerPage, isAutowatchEnabled);
    }

    @Override
    public String toString() {
        return "DefaultSettings{" +
                "preferences='" + preferences + '\'' +
                ", isNotifyUserAboutOwnChangesEnabled=" + isNotifyUserAboutOwnChangesEnabled +
                ", isSharePrivateEnabled=" + isSharePrivateEnabled +
                ", issuesPerPage=" + issuesPerPage +
                ", isAutowatchEnabled=" + isAutowatchEnabled +
                '}';
    }
}