package com.atlassian.jira.user;

import com.google.protobuf.ExperimentalApi;

import javax.annotation.Nullable;

/**
 * Controls what the behavior should be when a user clicks on an external link. It could be opened in the same tab/window,
 * replacing the current page, or in a new tab/window. The API consumer has to decide what to with such information,
 * e. g. add {@code target="_blank"} attribute to the corresponding {@code <a>} tag.
 *
 * @since 8.8
 */
@ExperimentalApi
public interface ExternalLinkInNewWindow {
    /**
     * Tells whether the opening external links in new tabs/windows is enabled for the given user.
     * When the feature is disabled globally, returns false for all users
     *
     * @param user user to check the setting for
     * @return true if the setting is enabled
     */
    boolean isEnabled(@Nullable ApplicationUser user);

    /**
     * Tells whether a link with given URL should open in a new tab/window when clicked by the given user.
     * Takes user preference into consideration.
     *
     * @param user user visiting the link
     * @param url address of the link
     * @return true if the link should be opened in a separate tab/window
     */
    boolean shouldOpenInNewWindow(@Nullable ApplicationUser user, @Nullable String url);
}
