package com.atlassian.jira.transition;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.workflow.JiraWorkflow;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * Manager to interact with Workflow transitions. It doesn't handle permission checks, which should be verified prior
 * to interacting with the manager.
 *
 * @since 7.6
 */
@ExperimentalApi
public interface TransitionManager {

    /**
     * Collects all possible transitions for the specified {@link JiraWorkflow}s
     *
     * @param workflows a {@link Collection} of {@link JiraWorkflow}
     * @return a {@link Collection} containing the {@link JiraWorkflow} along with their transitions
     */
    Collection<WorkflowTransitionEntry> getTransitions(@Nonnull Collection<JiraWorkflow> workflows);
}