package com.atlassian.jira.transition;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Represents transition in Workflow
 *
 * @since 7.6
 */
@ExperimentalApi
public interface TransitionEntry {
    /**
     * @return the id of the transition
     */
    int getTransitionId();

    /**
     * @return the id of from status
     */
    Long getFromStatusId();

    /**
     * @return the id of the to status
     */
    Long getToStatusId();

    /**
     * @return the name of transition
     */
    String getName();

    /**
     * @return if has screen
     */
    boolean getHasScreen();

    /**
     * @return if has conditions
     */
    boolean getHasConditions();

    /**
     * @return if has validators
     */
    boolean getHasValidators();

    /**
     * @return if is global
     */
    boolean getIsGlobal();

    /**
     * @return if is initial
     */
    boolean getIsInitial();

}