package com.atlassian.jira.sharing.type;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.UserShareTypeSearchParameter;
import com.atlassian.jira.util.dbc.Assertions;

/**
 * wrapper for UserShareType SharePermission with convenience accessors and assertions.
 *
 * @since v7.12
 */
public class UserSharePermission {
    private final SharePermission permission;

    public UserSharePermission(final SharePermission permission) {
        Assertions.equals("permission type", ShareType.Name.USER, permission.getType());
        this.permission = permission;
    }

    public String getUserKey() {
        return permission.getParam1();
    }

    public UserShareTypeSearchParameter getSearchParameter() {
        return new UserShareTypeSearchParameter(getUserKey());
    }
}
