package com.atlassian.jira.sharing.search;

import com.atlassian.jira.sharing.type.ShareType;

import java.util.Objects;

/**
 * Represents the search parameters when searching for User ShareTypes. The object can be used to search for SharePermissions
 * that share with a particular user by passing a User Name.
 *
 * @since v7.12
 */
public class UserShareTypeSearchParameter extends AbstractShareTypeSearchParameter {
    private final String userKey;

    public UserShareTypeSearchParameter(String userKey) {
        super(ShareType.Name.USER);
        this.userKey = userKey;
    }

    public String getUserKey() {
        return userKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserShareTypeSearchParameter that = (UserShareTypeSearchParameter) o;
        return Objects.equals(userKey, that.userKey);
    }

    @Override
    public int hashCode() {
        return (userKey != null ? userKey.hashCode() : 0);
    }
}
