package com.atlassian.jira.sharing.rights;

import com.atlassian.annotations.ExperimentalApi;

/**
 * @since v7.12
 */
@ExperimentalApi
public interface ShareRight {
    /**
     * Checks if this share right gives rights to view and edit
     *
     * @return true if this share right gives rights to view and edit, false otherwise
     */
    @ExperimentalApi
    boolean hasEditRightsGranted();

    /**
     * Checks if this share right gives rights to view
     *
     * @return true if this share right gives rights to view, false otherwise
     */
    @ExperimentalApi
    boolean hasViewRightsGranted();
}
