package com.atlassian.jira.plugin.searchrequestview;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.util.http.JiraHttpUtils;

import java.io.Writer;

/**
 * Extendend this abstract class to implement custom SearchRequestViews.  By default this
 * class does not produce any custom headers.  You only have to implement the writeSearchResults method.
 *
 * @see com.atlassian.jira.plugin.searchrequestview.SearchRequestView
 */
@PublicSpi
public abstract class AbstractSearchRequestView implements SearchRequestView {
    protected SearchRequestViewModuleDescriptor descriptor;

    public void init(SearchRequestViewModuleDescriptor moduleDescriptor) {
        this.descriptor = moduleDescriptor;
    }

    /**
     * A default implementation which sets headers the explicitly tell the browser not to cache
     * the content generated by this SearchRequestView. Override this method if you would like
     * to change this behaviour.
     */
    public void writeHeaders(SearchRequest searchRequest, RequestHeaders requestHeaders) {
        JiraHttpUtils.setNoCacheHeaders(requestHeaders);
    }

    /**
     * By default we don't care about the user agent
     */
    @Override
    public void writeHeaders(final SearchRequest searchRequest, final RequestHeaders requestHeaders, final SearchRequestParams searchRequestParams) {
        writeHeaders(searchRequest, requestHeaders);
    }

    public abstract void writeSearchResults(SearchRequest searchRequest, SearchRequestParams searchRequestParams, Writer writer)
            throws SearchException;
}
