package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.query.clause.TerminalClause;

import java.util.ArrayList;
import java.util.List;

/**
 * Factory for producing clauses for the custom fields that have a raw index value
 *
 * @since v6.4
 */
public class NumberCustomFieldClauseQueryFactory implements ClauseQueryFactory {
    private final ClauseQueryFactory delegateClauseQueryFactory;

    //CLOVER:OFF
    public NumberCustomFieldClauseQueryFactory(String luceneField, JqlOperandResolver operandResolver, DoubleConverter doubleConverter, boolean supportsRelational) {
        final List<OperatorSpecificQueryFactory> operatorFactories = new ArrayList<>();
        // we can't use special value Double.MAX_VALUE for JQL `is Empty` because it may not be indexed.
        operatorFactories.add(new NumberEqualityQueryFactory(doubleConverter));
        if (supportsRelational) {
            operatorFactories.add(new NumberRelationalQueryFactory(doubleConverter));
        }
        this.delegateClauseQueryFactory = new GenericClauseQueryFactory(luceneField, operatorFactories, operandResolver);
    }

    public QueryFactoryResult getQuery(final QueryCreationContext queryCreationContext, final TerminalClause terminalClause) {
        return delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause);
    }
    //CLOVER:ON
}
