package com.atlassian.jira.jql.query;

import com.atlassian.jira.util.Function;
import com.atlassian.query.operator.Operator;
import org.apache.lucene.search.Query;

import java.util.List;

import static com.atlassian.jira.util.dbc.Assertions.notNull;

/**
 * @since v8.0
 */
public abstract class AbstractRangeQueryFactory<T,U> {

    protected final Function<T, U> valueFactory;

    protected AbstractRangeQueryFactory(final Function<T,U> valueFactory) {
        this.valueFactory = notNull("valueFactory", valueFactory);
    }


    Query get(final Operator operator, final String fieldName, final T value) {
        switch (operator) {
            case LESS_THAN:
                return handleLessThan(fieldName, value);
            case LESS_THAN_EQUALS:
                return handleLessThanEquals(fieldName, value);
            case GREATER_THAN:
                return handleGreaterThan(fieldName, value);
            case GREATER_THAN_EQUALS:
                return handleGreaterThanEquals(fieldName, value);
            default:
                // should not have gotten here
                throw new IllegalArgumentException("Unhandled Operator: " + operator);
        }
    }

    Query get(final Operator operator, final String fieldName, final List<T> values) {
        if (operator == Operator.DURING) {
            if (values.get(0) == null) {
                return handleLessThanEquals(fieldName, values.get(1));
            } else if (values.get(1) == null) {
                return handleGreaterThanEquals(fieldName, values.get(0));
            } else {
                return handleDuring(fieldName, values.get(0), values.get(1));
            }
        } else {
            // should not have gotten here
            throw new IllegalArgumentException("Unhandled Operator: " + operator);
        }
    }




    abstract Query handleLessThan(final String fieldName, final T value);

    abstract Query handleLessThanEquals(final String fieldName, final T value);

    abstract Query handleGreaterThan(final String fieldName, final T value);

    abstract Query handleGreaterThanEquals(final String fieldName, final T value);

    abstract Query handleDuring(final String fieldName, final T lowerValue, final T upperValue);

}
