package com.atlassian.jira.jql.builder;

import javax.annotation.concurrent.NotThreadSafe;

/**
 * A builder for {@link JqlFieldReference}
 */
@NotThreadSafe
public class JqlFieldReferenceBuilder {
    private String name;
    private String property;
    private String reference;

    JqlFieldReferenceBuilder() {}

    /**
     * Specify the field name for {@link JqlFieldReference}
     * @param name field name
     * @return the builder
     */
    public JqlFieldReferenceBuilder withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Specify the property {@link JqlFieldReference}
     *
     * @param property property key
     * @return the builder
     */
    public JqlFieldReferenceBuilder withProperty(String property) {
        this.property = property;
        return this;
    }

    /**
     * Specify and object reference in {@link JqlFieldReference}
     *
     * @param reference object reference
     * @return
     */
    public JqlFieldReferenceBuilder withReference(String reference) {
        this.reference = reference;
        return this;
    }

    /**
     * Builds the {@link JqlFieldReference}
     *
     * @return
     */
    public JqlFieldReference build() {
        return new JqlFieldReference(this.name, this.property, this.reference);
    }
}
