package com.atlassian.jira.issue.index.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.index.IndexingFeatures;

/**
 * Published when JIRA starts.
 */
@EventName("jira.indexing.stats")
@Internal
public class JiraIndexingStatsAnalyticsEvent {
    private final boolean cfvValueDrivenIndexingEnabled;
    private final boolean localContextIndexingEnabled;
    private final boolean skipIndexingNullEnabled;
    private final int totalIndexers;
    private final int indexersDeclaringNullHandling;
    private final int indexersSkippingNull;
    private final int customFieldIndexingBatchSize;
    private final int totalCustomFieldTypes;
    private final long customFieldTypesImplementingBatchCustomFieldInfo;

    @Deprecated
    public JiraIndexingStatsAnalyticsEvent(final IndexingFeatures indexingFeatures,
                                           final int totalIndexers,
                                           final int indexersDeclaringNullHandling,
                                           final int indexersSkippingNull) {
        throw new UnsupportedOperationException();
    }

    public JiraIndexingStatsAnalyticsEvent(final IndexingFeatures indexingFeatures,
                                           final int totalIndexers,
                                           final int indexersDeclaringNullHandling,
                                           final int indexersSkippingNull,
                                           final int totalCustomFieldTypes,
                                           final long customFieldTypesImplementingBatchCustomFieldInfo) {
        this.cfvValueDrivenIndexingEnabled = indexingFeatures.isCFValueDrivenIndexingEnabled();
        this.localContextIndexingEnabled = indexingFeatures.isLocalContextIndexingEnabled();
        this.skipIndexingNullEnabled = indexingFeatures.isSkipIndexingNullEnabled();
        this.totalIndexers = totalIndexers;
        this.indexersDeclaringNullHandling = indexersDeclaringNullHandling;
        this.indexersSkippingNull = indexersSkippingNull;
        this.customFieldIndexingBatchSize = indexingFeatures.getCustomFieldIndexingBatchSize();
        this.totalCustomFieldTypes = totalCustomFieldTypes;
        this.customFieldTypesImplementingBatchCustomFieldInfo = customFieldTypesImplementingBatchCustomFieldInfo;
    }

    /**
     * @return true if custom field value driven index is enabled otherwise false.
     */
    public boolean isCfvValueDrivenIndexingEnabled() {
        return cfvValueDrivenIndexingEnabled;
    }

    /**
     * @return true if local context index is enabled otherwise false.
     */
    public boolean isLocalContextIndexingEnabled() {
        return localContextIndexingEnabled;
    }

    /**
     * @return true if skip indexing null is enabled otherwise false.
     */
    public boolean isSkipIndexingNullEnabled() {
        return skipIndexingNullEnabled;
    }

    /**
     * @return number of custom field indexers.
     */
    public int getTotalIndexers() {
        return totalIndexers;
    }

    /**
     * @return number of custom field indexers that declare null handling.
     */
    public int getIndexersDeclaringNullHandling() {
        return indexersDeclaringNullHandling;
    }

    /**
     * @return number of custom field indexers that skip indexing nulls.
     */
    public int getIndexersSkippingNull() {
        return indexersSkippingNull;
    }

    /**
     * @return number representing custom field indexing value retrieval batch size.
     */
    public int getCustomFieldIndexingBatchSize() {
        return customFieldIndexingBatchSize;
    }

    /**
     * @return number representing total amount of custom field types.
     */
    public int getTotalCustomFieldTypes() {
        return totalCustomFieldTypes;
    }

    /**
     * @return number representing amount of custom field types implementing batch api.
     */
    public long getCustomFieldTypesImplementingBatchCustomFieldInfo() {
        return customFieldTypesImplementingBatchCustomFieldInfo;
    }
}
