package com.atlassian.jira.issue.index;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.config.ReindexMessage;

import javax.annotation.Nullable;

/**
 * Event raised when a "reindex all" event is beginning. This is the event triggered when e.g. the
 * admin clicks reindex or new data is imported.
 * <p>
 * This Class should not be constructed by consumers of the API.
 *
 * @since v5.0
 */
@PublicApi
@EventName("reindex.all.started")
public class ReindexAllStartedEvent implements IndexEvent {
    private final boolean useBackgroundIndexing;
    private final boolean notifyCluster;
    private final IssueIndexingParams issueIndexingParams;
    private final String reason;
    private final String indexingLanguage;

    // added to keep the APICheck happy
    @SuppressWarnings("unused")
    @Deprecated
    public ReindexAllStartedEvent() {
        this(false, false);
    }

    @Deprecated
    public ReindexAllStartedEvent(final boolean useBackgroundIndexing, final boolean notifyCluster) {
        this(useBackgroundIndexing, notifyCluster, IssueIndexingParams.INDEX_ALL, null);
    }

    @Internal
    @Deprecated
    public ReindexAllStartedEvent(final boolean useBackgroundIndexing, final boolean notifyCluster, IssueIndexingParams issueIndexingParams, @Nullable ReindexMessage message) {
        this(useBackgroundIndexing, notifyCluster, issueIndexingParams, message, "NOT SPECIFIED");
    }

    @Internal
    public ReindexAllStartedEvent(final boolean useBackgroundIndexing, final boolean notifyCluster, IssueIndexingParams issueIndexingParams, @Nullable ReindexMessage message,
                                  final String indexingLanguage) {
        this.useBackgroundIndexing = useBackgroundIndexing;
        this.notifyCluster = notifyCluster;
        this.issueIndexingParams = issueIndexingParams;
        this.reason = message != null ? message.getI18nTaskKey() : null;
        this.indexingLanguage = indexingLanguage;
    }

    public boolean isUsingBackgroundIndexing() {
        return useBackgroundIndexing;
    }

    /**
     * @deprecated Use {@link #shouldNotifyCluster()} instead. Since v8.9.
     */
    public boolean shouldUpdateReplicatedIndex() {
        return shouldNotifyCluster();
    }

    public boolean shouldNotifyCluster() {
        return notifyCluster;
    }

    public IssueIndexingParams getIssueIndexingParams() {
        return issueIndexingParams;
    }

    @SuppressWarnings("unused")
    public boolean isIndexIssues() {
        return issueIndexingParams.isIndexIssues();
    }

    @SuppressWarnings("unused")
    public boolean isIndexChangeHistory() {
        return issueIndexingParams.isIndexChangeHistory();
    }

    @SuppressWarnings("unused")
    public boolean isIndexComments() {
        return issueIndexingParams.isIndexComments();
    }

    @SuppressWarnings("unused")
    public boolean isIndexWorklogs() {
        return issueIndexingParams.isIndexWorklogs();
    }

    public String getReason() {
        return reason;
    }

    public String getIndexingLanguage() {
        return indexingLanguage;
    }
}
