package com.atlassian.jira.issue.fields.rest.json.beans;

import com.google.common.collect.Lists;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.List;

/**
 * A JSON-convertable representation of either the creation or update of an issue type scheme.
 * Intended to be used as part of a RESTful request.
 *
 * @since 8.0
 */
public class IssueTypeSchemeCreateUpdateBean {

    static final IssueTypeSchemeCreateUpdateBean EXAMPLE;
    static {
        IssueTypeSchemeCreateUpdateBean bean = new IssueTypeSchemeCreateUpdateBean();
        bean.setName("new name");
        bean.setDescription("some new description of the scheme");
        bean.setDefaultIssueTypeId("3");
        bean.setIssueTypeIDs(Lists.newArrayList("1", "4", "3"));
        EXAMPLE = bean;
    }

    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String defaultIssueTypeId;


    @JsonProperty
    private List<String> issueTypeIds;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultIssueTypeId() {
        return defaultIssueTypeId;
    }

    public void setDefaultIssueTypeId(String defaultIssueTypeId) {
        this.defaultIssueTypeId = defaultIssueTypeId;
    }

    public List<String> getIssueTypeIds() {
        return issueTypeIds;
    }

    public void setIssueTypeIDs(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
    }
}
