package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.annotations.ExperimentalApi;
import java.util.function.BiFunction;

import java.util.function.BiFunction;

/**
 * Functions which calculate self address of properties for various entities.
 *
 * @since v6.2
 */
@ExperimentalApi
public class EntityPropertyBeanSelfFunctions {
    /**
     * @since 7.0.0
     */
    public static BiFunction<Long, String, String> EMPTY_BIFUNCTION = (aLong, s) -> "";

    /**
     * @since 7.0.0
     */
    public static class IssuePropertySelfBiFunction implements BiFunction<Long, String, String> {
        @Override
        public String apply(final Long entityId, final String encodedPropertyKey) {

            return String.format("issue/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }


    /**
     * @since 7.0.0
     */
    public static class ProjectPropertySelfBiFunction implements BiFunction<Long, String, String> {
        @Override
        public String apply(final Long entityId, final String encodedPropertyKey) {
            return String.format("project/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }

    /**
     * @since 7.0.0
     */
    public static class CommentPropertySelfBifFunction implements BiFunction<Long, String, String> {
        @Override
        public String apply(final Long entityId, final String encodedPropertyKey) {
            return String.format("comment/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }

    public static BiFunction<Long, String, String> dashboardItemPropertySelfBiFunction(String dashboardId) {
        return new DashboardItemPropertySelfBiFunction(dashboardId);
    }

    /**
     * @since 7.0.0
     */
    private static class DashboardItemPropertySelfBiFunction implements BiFunction<Long, String, String> {
        private final String dashboardId;

        public DashboardItemPropertySelfBiFunction(final String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public String apply(final Long entityId, final String encodedPropertyKey) {
            return String.format("dashboard/%s/items/%d/properties/%s", dashboardId, entityId, encodedPropertyKey);
        }
    }

    /**
     * @since 7.0.0
     */
    public static class IssueTypePropertySelfBiFunction implements BiFunction<Long, String, String> {
        @Override
        public String apply(final Long entityId, final String encodedPropertyKey) {
            return String.format("issuetype/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }
}
