package com.atlassian.jira.issue.fields.rest.json.beans;

import com.google.common.collect.Lists;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * JSON-convertible representation of a collection of keys or ids (or, some combination of them both) that uniquely
 * identify projects.
 *
 * @since 8.0
 */
public class AssociateProjectsBean {

    static final AssociateProjectsBean EXAMPLE;

    static {
        final AssociateProjectsBean ex = new AssociateProjectsBean();
        ex.idsOrKeys = Lists.newArrayList("100034", "13543", "FOOPROJ", "BAZZPROJ");
        EXAMPLE = ex;
    }


    @JsonProperty
    private List<String> idsOrKeys;

    public List<String> getIdsOrKeys() {
        return idsOrKeys;
    }

    public void setIdsOrKeys(List<String> idsOrKeys) {
        this.idsOrKeys = idsOrKeys;
    }

}
