package com.atlassian.jira.issue.customfields.vdi;

import com.atlassian.jira.issue.Issue;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * A wrapper class that contains data retrieved during custom value check done in {@link NonNullCustomFieldProvider#getCustomFieldInfo(List <Issue>)}.
 * Can contain anything and should be used by subclassess of {@link com.atlassian.jira.issue.index.indexers.FieldIndexer} to reduce the amount of
 * data retrieved during indexing.
 */
public class CustomFieldPrefetchedData {
    /**
     * Note that disabling prefetch means that your custom field data will be retrieved twice - do not use it unless you already cache that
     * value internally.
     */
    public static final CustomFieldPrefetchedData NO_PREFETCH = new CustomFieldPrefetchedData();
    private final Optional<Object> opaqueData;

    public CustomFieldPrefetchedData(final Object opaqueData) {
        Objects.requireNonNull(opaqueData);
        this.opaqueData = Optional.of(opaqueData);
    }

    private CustomFieldPrefetchedData() {
        opaqueData = Optional.empty();
    }

    public Optional<Object> getData() {
        return opaqueData;
    }
}
