package com.atlassian.jira.issue.customfields;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.Issue;
import org.apache.lucene.document.Document;

import java.util.Map;

/**
 * Provides a collection of nonnull custom fields of a given issue. The {@link #getIdentity()} will be used
 * for deduplication of a provider that have multiple instances (e.g. Spring Proxies around the core instance).
 * See also {@link com.atlassian.jira.component.IdentifiableComponent}.
 *
 * @deprecated since 8.12 use {@link com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData} instead.
 */
@Deprecated
@ExperimentalApi
public interface NonnullCustomFieldProvider {
    /**
     * @param issue the id of the issue
     * @return a map, where the keys are a collection of nonnull value custom field associated with the given issue and known to this provider
     * and the nullable values are prefetched data objects passed on to the indexer of this custom field. See {@link com.atlassian.jira.issue.index.indexers.FieldIndexer#addIndex(Document, Issue, CustomFieldPrefetchedData)}
     *
     */
    Map<String, CustomFieldPrefetchedData> getCustomFieldInfo(Issue issue);

    /**
     * @return the identity of this provider. The identity will be used for equality check to ensure that any proxy of
     * a provider will equal to it.
     */
    Object getIdentity();
}
