package com.atlassian.jira.issue;

/**
 * A holder for constants representing each type of Action in the sense that
 * comment and worklog entities were known as Actions. This should not be
 * confused with Webwork Actions.
 * NOTE: Since 2008 (check upgrade tasks in 243b899ae6a4c151c6ad355ceb2caa569214f130) the Action
 * table contains comments only - marking other types as deprecated.
 */
public final class ActionConstants {
    /**
     * A comment on an issue that has an author, a body, and optionally,
     * a group level and role level.
     */
    public static final String TYPE_COMMENT = "comment";

    @Deprecated
    public static final String TYPE_FIELDCHANGE = "fieldchange";

    /**
     * A work log entry.
     */
    @Deprecated
    public static final String TYPE_WORKLOG = "worklog";

    private ActionConstants() {
    }
}
