package com.atlassian.jira.event.user;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginReason;
import com.atlassian.jira.user.ApplicationUser;

import javax.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

/**
 * Published when user failed logging in.
 *
 * @since v8.12.2
 */
@Internal
public class LoginFailedEvent extends UserEvent {

    private final LoginInfo loginInfo;
    private final LoginReason loginReason;
    private final String accessUrl;

    public LoginFailedEvent(ApplicationUser user, LoginInfo loginInfo, LoginReason loginReason) {
        this(user, loginInfo, loginReason, null);
    }

    public LoginFailedEvent(ApplicationUser user, LoginInfo loginInfo, LoginReason loginReason, @Nullable String accessUrl) {
        super(user, UserEventType.USER_LOGIN_FAILED);
        this.loginInfo = loginInfo;
        this.loginReason = loginReason;
        this.accessUrl = accessUrl;
    }

    public LoginInfo getLoginInfo() {
        return loginInfo;
    }

    public LoginReason getLoginReason() {
        return loginReason;
    }

    public Optional<String> getUrl() {
        return Optional.ofNullable(accessUrl);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LoginFailedEvent that = (LoginFailedEvent) o;
        return Objects.equals(loginInfo, that.loginInfo) &&
                loginReason == that.loginReason &&
                Objects.equals(accessUrl, that.accessUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), loginInfo, loginReason, accessUrl);
    }
}
