package com.atlassian.jira.event.user;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;

import javax.annotation.Nullable;
import java.util.Locale;

/**
 * Published when a user successfully logs in.
 */
@PublicApi
public final class LoginEvent extends UserEvent {
    private final String locale;

    public LoginEvent(ApplicationUser user) {
        this(user, null);
    }

    public LoginEvent(ApplicationUser user, @Nullable Locale locale) {
        super(user, UserEventType.USER_LOGIN);

        this.locale = locale == null ? null : locale.toString();
    }

    public String getLocale() {
        return locale;
    }
}
