package com.atlassian.jira.event.sharedentity;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.sharing.SharedEntity;

import javax.annotation.Nonnull;

/**
 * Event published when shared entity (i.e. filer or dashboard) has been updated
 *
 * @since v7.12
 */
@ExperimentalApi
public class SharedEntityUpdatedEvent extends AbstractSharedEntityEvent {

    public SharedEntityUpdatedEvent(@Nonnull SharedEntity entityFrom, @Nonnull SharedEntity entityTo) {
        super(entityFrom, entityTo);
    }
}
