package com.atlassian.jira.event.sharedentity;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.sharing.SharedEntity;

import javax.annotation.Nonnull;

/**
 * Event published when shared entity (i.e. filer or dashboard) has been deleted
 *
 * @since v7.12
 */
@ExperimentalApi
public class SharedEntityDeletedEvent extends AbstractSharedEntityEvent {
    public SharedEntityDeletedEvent(@Nonnull SharedEntity deletedEntity) {
        super(deletedEntity, null);
    }
}
