package com.atlassian.jira.event.sharedentity;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.dbc.Assertions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Abstract event related to shared entity (i.e. filer or dashboard) actions
 *
 * @since v7.12
 */
@ExperimentalApi
public class AbstractSharedEntityEvent {

    private SharedEntity entityFrom;
    private SharedEntity entityTo;

    AbstractSharedEntityEvent(@Nullable SharedEntity entityFrom, @Nullable SharedEntity entityTo) {
        Assertions.is("At least one of the Events must not be null!", entityFrom != null || entityTo != null);
        this.entityFrom = entityFrom;
        this.entityTo = entityTo;
    }

    @Nullable
    public SharedEntity getEntityFrom() {
        return entityFrom;
    }

    @Nullable
    public SharedEntity getEntityTo() {
        return entityTo;
    }

    @Nonnull
    public SharedEntity getChangedEntity() {
        return (entityFrom == null) ? entityTo : entityFrom;
    }
}
