package com.atlassian.jira.event.service;

import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.service.JiraServiceContainer;

import javax.annotation.Nonnull;

/**
 * Abstract event related to services.
 *
 * @since v8.6
 */
public abstract class AbstractServiceEvent extends AbstractEvent {
    protected final JiraServiceContainer jiraServiceContainer;

    AbstractServiceEvent(@Nonnull final JiraServiceContainer jiraServiceContainer) {
        this.jiraServiceContainer = jiraServiceContainer;
    }

    @Nonnull
    public JiraServiceContainer getJiraServiceContainer() {
        return jiraServiceContainer;
    }
}
