package com.atlassian.jira.event.operation;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Type of operations supported and marked by default by Jira.
 *
 * @since 7.13
 */
@ExperimentalApi
public enum SpanningOperationType {
    /**
     * currently not used
     */
    BULK_MOVE,
    /**
     * bulk move of issues
     */
    BULK_MIGRATE,
    /**
     * bulk edit of issues
     */
    BULK_EDIT,
    /**
     * bulk delete of issues
     */
    BULK_DELETE,
    /**
     * bulk archive of issues
     */
    BULK_ARCHIVE,
    /**
     * bulk workflow transition of issues
     */
    BULK_WORKFLOW_TRANSITION,
    /**
     * bulk adding watchers to issues
     */
    BULK_WATCH,
    /**
     * bulk removing watchers to issues
     */
    BULK_UNWATCH,
    /**
     * bulk edit when changing issue type scheme and issues have to be migrated
     */
    BULK_MIGRATE_ISSUE_TYPES,
    /**
     * restore from backup
     */
    EXTERNAL_IMPORT,
    /**
     * restore during set-up
     */
    SETUP_IMPORT
}
