package com.atlassian.jira.event.mail;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.mail.queue.MailQueue;

import javax.annotation.Nonnull;

/**
 * Event published when mail queue is flushed.
 *
 * @since v8.7
 */

@ExperimentalApi
//TODO: make this class final once EmailQueueFl_a_shedEvent is removed from the codebase
public class EmailQueueFlushedEvent extends AbstractEvent {
    protected final MailQueue queue;

    public EmailQueueFlushedEvent(@Nonnull final MailQueue queue) {
        this.queue = queue;
    }

    @Nonnull
    public MailQueue getMailQueue() {
        return queue;
    }
}
