package com.atlassian.jira.event.issuetype.screenscheme;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;

import javax.annotation.Nonnull;

/**
 * Event fired when an issue type screen scheme has been updated
 *
 * @since v8.7
 */
@ExperimentalApi
public class IssueTypeScreenSchemeUpdatedEvent extends AbstractIssueTypeScreenSchemeEvent {
    private final IssueTypeScreenScheme newScheme;

    public IssueTypeScreenSchemeUpdatedEvent(@Nonnull final IssueTypeScreenScheme previousScheme, @Nonnull final IssueTypeScreenScheme newScheme) {
        super(previousScheme);
        this.newScheme = newScheme;
    }

    @Nonnull
    public IssueTypeScreenScheme getNewIssueTypeScreenScheme() {
        return newScheme;
    }
}
