package com.atlassian.jira.event.issuetype.screenscheme;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;

import javax.annotation.Nonnull;

/**
 * Event fired when an issue type screen scheme has been created
 *
 * @since v8.7
 */
@ExperimentalApi
public class IssueTypeScreenSchemeCreatedEvent extends AbstractIssueTypeScreenSchemeEvent {

    public IssueTypeScreenSchemeCreatedEvent(@Nonnull final IssueTypeScreenScheme scheme) {
        super(scheme);
    }
}
