package com.atlassian.jira.event.issuetype.screenscheme;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.issuetype.IssueType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event fired when a screen scheme is associated to a issue type screen scheme
 *
 * @since v8.7
 */
@ExperimentalApi
public class IssueTypeScreenSchemeAssociateScreenSchemeEvent extends AbstractIssueTypeScreenSchemeEvent {
    private final IssueType issueType;
    private final FieldScreenScheme fieldScreenScheme;

    public IssueTypeScreenSchemeAssociateScreenSchemeEvent(@Nonnull IssueTypeScreenScheme scheme, @Nullable IssueType issueType, @Nonnull FieldScreenScheme fieldScreenScheme) {
        super(scheme);
        this.issueType = issueType;
        this.fieldScreenScheme = fieldScreenScheme;
    }

    public IssueType getIssueType() {
        return issueType;
    }

    public FieldScreenScheme getFieldScreenScheme() {
        return fieldScreenScheme;
    }
}
