package com.atlassian.jira.event.issuetype.screenscheme;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;

import javax.annotation.Nonnull;

/**
 * Abstract event related to issue type screen schemes.
 *
 * @since v8.7
 */
@ExperimentalApi
abstract class AbstractIssueTypeScreenSchemeEvent extends AbstractEvent {
    private final IssueTypeScreenScheme scheme;

    AbstractIssueTypeScreenSchemeEvent(@Nonnull final IssueTypeScreenScheme scheme) {
        this.scheme = scheme;
    }

    @Nonnull
    public IssueTypeScreenScheme getIssueTypeScreenScheme() {
        return scheme;
    }
}
