package com.atlassian.jira.event.issue.security;

import com.atlassian.annotations.Internal;

import java.util.Objects;

/**
 * This event will be fired whenever {@link com.atlassian.jira.issue.security.IssueSecurityLevel} is updated.
 *
 * @since 8.12.0
 */
@Internal
public final class IssueSecurityLevelUpdatedEvent {

    private final String newName;
    private final String oldName;
    private final String newDescription;
    private final String oldDescription;
    private final Long schemeId;

    public IssueSecurityLevelUpdatedEvent(final String newName,
                                          final String oldName,
                                          final String newDescription,
                                          final String oldDescription,
                                          final Long schemeId) {
        this.newName = newName;
        this.oldName = oldName;
        this.newDescription = newDescription;
        this.oldDescription = oldDescription;
        this.schemeId = schemeId;
    }

    public String getNewName() {
        return newName;
    }

    public String getOldName() {
        return oldName;
    }

    public String getNewDescription() {
        return newDescription;
    }

    public String getOldDescription() {
        return oldDescription;
    }

    public Long getSchemeId() {
        return schemeId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final IssueSecurityLevelUpdatedEvent that = (IssueSecurityLevelUpdatedEvent) o;
        return Objects.equals(newName, that.newName) &&
                Objects.equals(oldName, that.oldName) &&
                Objects.equals(newDescription, that.newDescription) &&
                Objects.equals(oldDescription, that.oldDescription) &&
                Objects.equals(schemeId, that.schemeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(newName, oldName, newDescription, oldDescription, schemeId);
    }
}
