package com.atlassian.jira.event.issue.link;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.event.AbstractEvent;
import com.google.common.collect.Sets;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Signals, that the jql with 'linkedIssueType' was executed.
 *
 * @since v8.0
 */
@EventName("jql.search.issuelinktype")
public class JqlSearchIssueLinkTypeEvent extends AbstractEvent {
    private final static Set<String> KNOWN_LINK_TYPES = Sets.newHashSet("blocks", "is blocked by", "relates to", "duplicates", "is duplicated by", "clones", "is cloned by");

    private final String operator;
    private final List<String> values;

    public JqlSearchIssueLinkTypeEvent(String operator, List<String> values) {
        this.operator = operator;
        this.values = values.stream().map(v -> KNOWN_LINK_TYPES.contains(v) ? v : "unknown").collect(Collectors.toList());
    }

    public String getOperator() {
        return operator;
    }

    public List<String> getValues() {
        return values;
    }
}
