package com.atlassian.jira.event.issue.link;

import com.atlassian.jira.issue.link.IssueLink;

import java.time.Instant;

/**
 * Signals that an issue link was created. The issue link is visible via {@link com.atlassian.jira.issue.link.IssueLinkManager}.
 */
public class IssueLinkDeletedEvent {

    private final IssueLink issueLink;
    private final Instant eventCreation;

    public IssueLinkDeletedEvent(final IssueLink issueLink, final Instant eventCreation) {
        this.issueLink = issueLink;
        this.eventCreation = eventCreation;
    }

    public IssueLink getIssueLink() {
        return issueLink;
    }

    public Instant getEventCreation() {
        return eventCreation;
    }
}