package com.atlassian.jira.event.issue.commit;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * This is a commit safe version of {@link IssueEventBundle} event. The {@link OnCommitIssueEventBundle} is supposed to
 * be fired on commit if it's in a transaction, otherwise fired immediately.
 * <p>
 * While {@link IssueEventBundle} may be fired before commit.
 * <p>
 * This means that when listening to {@link IssueEventBundle} event, inaccurate data may be retrieved from database,
 * while listening to {@link OnCommitIssueEventBundle} guarantees the correct data.
 *
 * @since 7.4.0
 */
@ExperimentalApi
public interface OnCommitIssueEventBundle {
    @Nonnull
    Collection<OnCommitEvent> getOnCommitEvents();
}
